/*____________________________________________________________________________
	Copyright (C) 2000 Networks Associates Technology, Inc.
	All rights reserved.

	$Id: pgpIOUtilities.c,v 1.3 2000/07/27 20:51:06 wjb Exp $
____________________________________________________________________________*/
/*
 * pgpIOUtilities.c -- Sample code for using PGPIO
 */
#include "pgpPFLConfig.h"
#include "pgpPFLErrors.h"
#include "pgpMem.h"
#include "pgpIOUtilities.h"


/*____________________________________________________________________________
	Copy bytes from one I/O to another using supplied buffer. 
____________________________________________________________________________*/
	PGPError
PGPCopyIOUsingBuffer(
	PGPIORef	fromIO,
	PGPFileOffset numBytes,
	PGPIORef	toIO,
	void *		buffer,
	PGPSize		bufferSize )
{
	PGPFileOffset remaining;
	PGPError	err	= kPGPError_NoErr;
	
	remaining	= numBytes;
	while ( remaining != 0 )
	{	
		PGPSize count;
		
		// Minimum here of 64 bit and 32 bit will be 32 -wjb
		count	= (PGPSize)pgpMin( remaining, bufferSize );
		err	= PGPIORead( fromIO, count, buffer, NULL);
		if ( IsPGPError( err ) )
			break;
		
		err	= PGPIOWrite( toIO, count, buffer );
		if ( IsPGPError( err ) )
			break;
		
		remaining	-= count;
	}
	
	return( err );
}

/*____________________________________________________________________________
	Copy bytes from one I/O to another. 
	Caller will want to call PGPIOSetPos to set file mark first.
____________________________________________________________________________*/
	PGPError
PGPCopyIO(
	PGPIORef	fromIO,
	PGPFileOffset	numBytes,
	PGPIORef	toIO )
{
	void *			buffer	= NULL;
	PGPSize			bufferSize;
	PGPError		err	= kPGPError_NoErr;
	
	/* a reasonable cross-platform size */
	#define kBufferSize		( 32UL * 1024UL )
	
	// Minimum of 64 bit and 32 bit will be 32 bits -wjb
	bufferSize	= (PGPSize)pgpMin( numBytes, kBufferSize );
	buffer		= PGPNewData( PGPIOGetMemoryMgr( fromIO ), bufferSize, 0);
	if ( IsntNull( buffer ) )
	{
		err	= PGPCopyIOUsingBuffer( fromIO, numBytes, toIO,
				buffer, bufferSize );
			
		PGPFreeData( buffer );
	}
	else
	{
		err	= kPGPError_OutOfMemory;
	}
	return( err );
}


/*__Editor_settings____

	Local Variables:
	tab-width: 4
	End:
	vi: ts=4 sw=4
	vim: si
_____________________*/
